*Computation of MLD for two earnings measures, with and without respondents with missing information on covariates

*Tim Goedemé, 26/10/2020

/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/


*/

*globals // IS and SK dropped from list of countries

global place1 <<data directory ...\2020-04\>>
global place2 <<output directory ...\Estimations\>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK
set more off

*Estimations - 9 classes ONLY EU-SILC 2018

foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			
			forvalues x=1/2 {
				di `x'
				replace sub=0 if earns`x'<=0
				
				epctile1 earns`x', over(esec08) p(50) subpop(sub)
				
				mat def temp1 = e(results)
				local val=rowsof(temp1)
				cap mat drop tempmat
				forvalues row=1(1)`val' {
					mat def tempmat = nullmat(tempmat) \ `x'
				}
				mat colnames tempmat = earnings
				mat def matje = temp1, tempmat
				
				mat def results = nullmat(results) \ matje
			}
			
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\MedianEarnings_`ctry'_esec9.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\MedianEarnings_`ctry'_esec9.dta"
}
save "${place2}\MedianEarnings_Esec9_2018.dta", replace

*Reordering info to create graph in excel
use "${place2}\MedianEarnings_Esec9_2018.dta", clear

gen CIarm = UB-est
keep if earnings==2
drop se Percentile DF LB UB


reshape wide est CIarm, i(country) j(esec08)
order _all, seq

*Count of number of cases

foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			forvalues x=1/2 {
				di `x'
				cap mat drop freq0
				cap mat drop temp1
				ta esec08 if earns`x'>0 & earns`x'!=. & sub==1, matcell(freq0) matrow(cats)
				mat def temp1 = cats, freq0
				mat colnames temp1 = esec08 n			
				local val=rowsof(temp1)
				cap mat drop tempmat
				forvalues row=1(1)`val' {
					mat def tempmat = nullmat(tempmat) \ `x'
				}
				
				mat colnames tempmat = earnings
				mat def matje = temp1, tempmat
				
				mat def results = nullmat(results) \ matje
			}
			
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\Count_`ctry'_esec9.dta", replace // esec08
	}
}


clear
foreach ctry of global countries {
	append using "${place2}\Count_`ctry'_esec9.dta"
}
save "${place2}\Count_Esec9_2018.dta", replace

use "${place2}\Count_Esec9_2018.dta", clear
browse if earnings==2 & n<60


*******************************************
*Estimations - 3 classes ONLY EU-SILC 2018*
*******************************************

foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			cap drop class08
			
			gen class08 = 1 if esec08<3
			replace class08 = 2 if esec08>=3 & esec08<7
			replace class08 = 3 if esec08>=7 & esec08!=.
			
			
			forvalues x=1/2 {
				di `x'
				replace sub=0 if earns`x'<=0
				
				epctile1 earns`x', over(class08) p(50) subpop(sub)
				
				mat def temp1 = e(results)
				local val=rowsof(temp1)
				cap mat drop tempmat
				forvalues row=1(1)`val' {
					mat def tempmat = nullmat(tempmat) \ `x'
				}
				mat colnames tempmat = earnings
				mat def matje = temp1, tempmat
				
				mat def results = nullmat(results) \ matje
			}
			
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\MedianEarnings_`ctry'_esec3.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\MedianEarnings_`ctry'_esec3.dta"
}
save "${place2}\MedianEarnings_Esec3_2018.dta", replace

*Reordering info to create graph in excel
use "${place2}\MedianEarnings_Esec3_2018.dta", clear

gen CIarm = UB-est
keep if earnings==2
drop se Percentile DF LB UB


reshape wide est CIarm, i(country) j(class08)
order _all, seq
